<?php get_template_part( 'elements/onepage/part', 'title' ); ?>

<?php if (get_sub_field('map')) { ?>
	<section class="section-box section-map">
		<?php the_sub_field('map'); ?>
	</section>
<?php } ?>

<?php if( have_rows('google_map') ): ?>	
	<div class="acf-map">
		<?php while ( have_rows('google_map') ) : the_row();
			$location = get_sub_field('location');
			$title = get_sub_field('title');
			$desc = get_sub_field('description');
			$image = get_sub_field('image');
			if( !empty($image) ):
				// vars
				$url = $image['url'];
				$alt = $image['alt'];
	
				// thumbnail
				$marker = 'marker';
				$size = 'thumbnail';
				$thumb = $image['sizes'][ $size ];
				$markerthumb = $image['sizes'][ $marker ];
			endif; ?>
			

			
			<div class="marker" data-lat="<?php echo $location['lat']; ?>" data-lng="<?php echo $location['lng']; ?>" data-icon="<?php echo $markerthumb; ?>">
				<?php if ($image){ ?>
				<img class="img-responsive thumb" src="<?php echo $thumb; ?>" alt="<?php echo $alt; ?>"/>
				<?php } ?>
				<?php if ($title){ ?><?php echo $title; ?><?php } ?>
				<p class="address"><?php echo $location['address']; ?></p>
				<?php if ($desc){ ?><address><?php echo $desc; ?></address><?php } ?>
			</div>
		<?php endwhile; ?>
	</div>
<?php endif; ?>

<?php get_template_part( 'elements/onepage/part', 'outro' ); ?>